@extends('layout.front-end')
@section('title', 'Home')
@section('description', 'Home')
@section('content')

    <!-- Banner Start -->
    <div class="banner bg1">
        <div class="container">
            <div class="swiper swiper-homepage">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="row justify-content-between g-4 align-items-center">
                            <div class="col-lg-6">
                                <div class="banner-heading">
                                    <h1>Hosting in the Fast Lane</h1>
                                    <h4>Speed. Support. Intelligence</h4>
                                    <p>Everything you need to build a fast and successful website.</p>
                                    <ul class="list-check one">
                                        <li>FREE website migrations</li>
                                        <li>Unmatched 24/7/365 support</li>
                                        <li>AI powered performance optimizations</li>
                                        <li>TurboHub, our WordPress control panel</li>
                                    </ul>
                                    <div class="inline-btns mt-3">
                                        <a class="theme-btn one" href="#plans">Get Started </a>
                                        <a class="theme-btn two" href="#">Help Me Choose</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 d-none d-lg-block">
                                <div class="text-center">
                                    <img src="{{ asset(env('THEME') . '/images/herobanner2.png') }}" alt="img">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="row justify-content-between align-items-center">
                            <div class="col-lg-6">
                                <div class="banner-heading">
                                    <h1>Linux KVM VPS Hosting</h1>
                                    <h4>Scale Your Business Without Slowing Down</h4>
                                    <p>High-performance Servers for Faster Websites & Applications</p>
                                    <ul class="list-check one">
                                        <li>High-speed NVMe Storage</li>
                                        <li>Instant Provisioning</li>
                                        <li>Full Root Access</li>
                                    </ul>
                                    <!-- <h3 class="mt-2">Starting at $10.44/mo</h3> -->
                                    <div class="inline-btns mt-3">
                                        <a class="theme-btn one" href="vps-server.html">Get Started </a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 d-none d-lg-block">
                                <div class="text-center">
                                    <img src="{{ asset(env('THEME') . '/images/herobanner5.png') }}" alt="img"
                                        width="450">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </div>
    <!-- Banner End -->
    <main>
        <!-- We Provide Hosting for Every Solution Section Start -->
        <section class="section-gap">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="section-header center gap-bottom">
                            <h2>We Provide Hosting for Every Solution</h2>
                            <p>Lorem ipsum dolor sit, amet consectetur adipisicing.</p>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center align-items-center gy-4">
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <a class="services-design-one" href="shared-hosting.html">
                            <div class="img">
                                <img src="{{ asset(env('THEME') . '/images/shared_hosting_icon.webp') }}" alt="icon">
                            </div>
                            <h3>Shared Hosting</h3>
                            <p>Affordable web hosting with shared resources, ideal for small websites.</p>
                        </a>
                    </div>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <a class="services-design-one" href="reseller-hosting.html">
                            <div class="img">
                                <img src="{{ asset(env('THEME') . '/images/reseller_hosting_icon.webp') }}" alt="icon">
                            </div>
                            <h3>Reseller Hosting</h3>
                            <p>Offer web hosting services under your brand with reseller hosting.</p>
                        </a>
                    </div>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <a class="services-design-one" href="wordpress-hosting.html">
                            <div class="img">
                                <img src="{{ asset(env('THEME') . '/images/wordpress_hosting_icon.webp') }}" alt="icon">
                            </div>
                            <h3>WordPress Hosting</h3>
                            <p>Speedy, secure hosting crafted specifically for your WordPress site.</p>
                        </a>
                    </div>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <a class="services-design-one" href="cloud-hosting.html">
                            <div class="img">
                                <img src="{{ asset(env('THEME') . '/images/cloud_hosting_icon.webp') }}" alt="icon">
                            </div>
                            <h3>Cloud Hosting</h3>
                            <p>20x Faster, reliable hosting for dynamic websites and applications.</p>
                        </a>
                    </div>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <a class="services-design-one" href="vps-server.html">
                            <div class="img">
                                <img src="{{ asset(env('THEME') . '/images/vps_hosting_icon.webp') }}" alt="icon">
                            </div>
                            <h3>VPS Server</h3>
                            <p>Customize, control, power: VPS server hosting solution.</p>
                        </a>
                    </div>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <a class="services-design-one" href="dedicated-server.html">
                            <div class="img">
                                <img src="{{ asset(env('THEME') . '/images/dedicated_hosting_icon.webp') }}" alt="icon">
                            </div>
                            <h3>Dedicated Server</h3>
                            <p>Unmatched performance with exclusive dedicated server hosting.</p>
                        </a>
                    </div>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <a class="services-design-one" href="business-email.html">
                            <div class="img">
                                <img src="{{ asset(env('THEME') . '/images/mail_hosting_icon.webp') }}" alt="icon">
                            </div>
                            <h3>Email Hosting</h3>
                            <p>Efficient email solutions for seamless communication needs.</p>
                        </a>
                    </div>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <a class="services-design-one" href="ssl-certificates.html">
                            <div class="img">
                                <img src="{{ asset(env('THEME') . '/images/ssl_icon.webp') }}" alt="icon">
                            </div>
                            <h3>SSL Certificate</h3>
                            <p>Secure your site with trusted SSL certificates.</p>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- We Provide Hosting for Every Solution Section End -->
        <!-- Plan Section Start -->
        <section class="section-gap section-bg1" id="plans">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="section-header center gap-bottom">
                            <h2>Which Type of Hosting is Right for You?</h2>
                            <p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p>
                        </div>
                    </div>
                </div>
                <div class="row gy-4 gy-lg-0">
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <div class="plan-homepage">
                            <h3>Shared Hosting</h3>
                            <p>Economical hosting option sharing server resources for smaller-scale websites.</p>
                            <h4>$2.99/<span class="durection">mo*</span></h4>
                            <h5>Save 76% with 12/mo</h5>
                            <a class="theme-btn one" href="shared-hosting.html">View Plan</a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <div class="plan-homepage popular" data-popular="15% Off">
                            <h3>Wordpress Hosting</h3>
                            <p>Tailored hosting optimized for WordPress sites, ensuring speed and security.</p>
                            <h4>$3.48/<span class="durection">mo*</span></h4>
                            <h5>Save 76% with 12/mo</h5>
                            <a class="theme-btn one" href="wordpress-hosting.html">View Plan</a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <div class="plan-homepage">
                            <h3>Reseller Hosting</h3>
                            <p>Launch your own hosting business with reseller hosting, customizable and profitable.</p>
                            <h4>$3.98/<span class="durection">mo*</span></h4>
                            <h5>Save 76% with 12/mo</h5>
                            <a class="theme-btn one" href="reseller-hosting.html">View Plan</a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <div class="plan-homepage">
                            <h3>Cloud Hosting</h3>
                            <p>Flexible, scalable hosting solution for high-performance websites and applications.</p>
                            <h4>$1.88/<span class="durection">mo*</span></h4>
                            <h5>Save 76% with 12/mo</h5>
                            <a class="theme-btn one" href="cloud-hosting.html">View Plan</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Plan Section End -->
        <!-- Get a domain section start -->
        <section class="section-gap">
            <div class="container">
                <div class="row align-items-center justify-content-between">
                    <div class="col-lg-5">
                        <div class="section-header">
                            <h2>Get a domain that works for your business</h2>
                        </div>
                        <p>Help your consumers find you, make them remember you, and let them understand you. With hundreds
                            of domain extensions available, choose the best domain name that connects your business with
                            your customers.</p>
                        <a class="theme-btn one" href="domain-search.html">Get a Domain</a>
                    </div>
                    <div class="col-lg-6 d-none d-lg-block">
                        <div class="text-center">
                            <img src="{{ asset(env('THEME') . '/images/domainname.png') }}" alt="img">
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Get a domain section end -->
        <!-- FREE Add-ons Start -->
        <section class="section-gap section-bg2">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="section-header center white gap-bottom">
                            <h2>FREE Add-ons with every Domain Name!</h2>
                            <p>Get over $100 worth of Free Services with every Domain you Register</p>
                        </div>
                    </div>
                </div>
                <div class="row gy-5 gx-lg-5">
                    <div class="col-lg-6 col-sm-6 col-12">
                        <div class="services-design-two white">
                            <div class="img"><img src="{{ asset(env('THEME') . '/images/mail_icon.png') }}"
                                    alt="img"></div>
                            <h3>90-Day Free Trial - Titan Email</h3>
                            <p>Get 2 custom email accounts @yourdomain.com on a 90-day free trial. </p>
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-6 col-12">
                        <div class="services-design-two white">
                            <div class="img"><img src="{{ asset(env('THEME') . '/images/globe_icon.png') }}"
                                    alt="img">
                            </div>
                            <h3>Domain Forwarding</h3>
                            <p>Point your domain name to another website for free! Redirect users when they type your domain
                                name into a browser (with/without domain masking & SEO) </p>
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-6 col-12">
                        <div class="services-design-two white">
                            <div class="img"><img src="{{ asset(env('THEME') . '/images/management_icon.png') }}"
                                    alt="img">
                            </div>
                            <h3>DNS Management</h3>
                            <p>Free lifetime DNS service which allows you to manage your DNS records on our globally
                                distributed and highly redundant DNS infrastructure. </p>
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-6 col-12">
                        <div class="services-design-two white">
                            <div class="img"><img src="{{ asset(env('THEME') . '/images/protection_icon.png') }}"
                                    alt="img">
                            </div>
                            <h3>Domain Theft Protection</h3>
                            <p>Protect your Domain from being transferred out accidentally or without your permission with
                                our free Domain Theft Protection. </p>
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-6 col-12">
                        <div class="services-design-two white">
                            <div class="img"><img src="{{ asset(env('THEME') . '/images/tool_white_icon.png') }}"
                                    alt="img">
                            </div>
                            <h3>Bulk Tools</h3>
                            <p>Easy-to-use bulk tools to help you Register, Renew, Transfer and make other changes to
                                several Domain Names in a single step. </p>
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-6 col-12">
                        <div class="services-design-two white">
                            <div class="img"><img src="{{ asset(env('THEME') . '/images/control_icon.png') }}"
                                    alt="img">
                            </div>
                            <h3>Easy to use Control Panel</h3>
                            <p>Use our intuitive Control Panel to manage your domain name, configure email accounts, renew
                                your domain name and buy more services.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- FREE Add-ons End -->
        <!-- Security Section start -->
        <section class="section-gap">
            <div class="container">
                <div class="row align-items-center justify-content-between">
                    <div class="col-lg-6 d-none d-lg-block">
                        <div class="text-center">
                            <img src="{{ asset(env('THEME') . '/images/ssl.png') }}" alt="img">
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="section-header">
                            <h2>Enterprise-level Security to Protect What You Care About</h2>
                        </div>
                        <p>Privacy, integrity, data protection, network service protection and identification. and
                            authentication - we leave nothing for chance. Secure your website with enterprise-level security
                            with Digicerts & SSL, SiteLock, and CodeGuard.</p>
                        <div class="inline-btns">
                            <a class="theme-btn one" href="ssl-certificates.html">Get SSL</a>
                            <a class="theme-btn two" href="sitelock.html">Get Sitelock</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Security Section end -->
        <!-- Support Section start -->
        <section class="section-gap section-bg3">
            <div class="container">
                <div class="row align-items-center justify-content-between gy-4 gy-lg-0">
                    <div class="col-lg-6">
                        <div class="section-header">
                            <h2>Questions? We’re Here to Help.</h2>
                        </div>
                        <p>Got questions or need assistance? Our dedicated support team is here to help! Whether you need
                            technical guidance, billing assistance, or general information, we’re available 24/7 to provide
                            prompt and friendly support. You can reach out to us via email, phone, or live chat. Your
                            satisfaction is our priority, and we’re committed to resolving your issues quickly and
                            efficiently. Contact us anytime!</p>
                        <div class="inline-btns">
                            <a class="theme-btn one" href="contact.html">Contact Now</a>
                        </div>
                    </div>
                    <div class="col-lg-6 d-none d-lg-block">
                        <div class="text-center">
                            <img src="{{ asset(env('THEME') . '/images/helpdesk.png') }}" alt="img">
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Support Section end -->
    </main>
@endsection
